/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.clock.ClockImplementation;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.RTI;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class RTITest {
    @Test
    public void testExecute() throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        MemoryBlock memory = new MemoryBlock(65536);
        ClockImplementation clock = new ClockImplementation();
        cpu.attach(memory, clock);
        cpu.setPC(65244);
        cpu.setSP(new HwByte(252L));
        memory.write(511, 26);
        memory.write(510, 42);
        Flags6502 flags = new Flags6502();
        flags.setCarry(true);
        flags.setZero(true);
        memory.write(509, (int)flags.getNumber());
        RTI rti = new RTI();
        rti.execute(cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte(255L), (Object)cpu.getSP());
        Assert.assertEquals((Object)new HwWord(6698L), (Object)cpu.getPC());
        Assert.assertEquals((Object)flags, (Object)cpu.getFlags());
    }
}

